;*******************************
;*    DEMONTRATION PROGRAM 8   *
;*      DIGITAL TO ANALOG      *
;*******************************
;
            ORG    8000H
U25PA       EQU    0E0B0H
U25PB       EQU    0E0B1H
U25PC       EQU    0E0B2H
U25CTRL     EQU    0E0B3H
U28PA       EQU    0E0B4H
U28PB       EQU    0E0B5H
U28PC       EQU    0E0B6H
U28CTRL     EQU    0E0B7H
U21PA       EQU    0E0B8H
U21PB       EQU    0E0B9H
U21PC       EQU    0E0BAH
U21CTRL     EQU    0E0BBH
DA_PORT     EQU    U21PA           ;D to A Port
SEG_PORT    EQU    U21PB
SCAN_KYDP   EQU    27H
BCD_HEX     EQU    5               ;System call
CLRSCR      EQU    7               ;   "     "
HI_BEEP     EQU    18H             ;   "     "
ONE_TO_TWO  EQU    1DH             ;   "     "
TWO_IN_ONE  EQU    2EH             ;   "     "
WAIT_2KEY   EQU    33H             ;   "     "
GET_2KEY    EQU    12H             ;   "     "
SYSCALL     EQU    0030H
DISBUF      EQU    9F00H
D_A_BUF     EQU    22H
KEY_STAT    EQU    36H             ;Variable in BIOS
REPEAT      EQU    30H             ; "           "
DEM91:      MOV    DPTR,#U28CTRL
            MOV    A,#81H
            MOVX   @DPTR,A
            MOV    DPTR,#U28PA
            MOV    A,#0FFH
            MOVX   @DPTR,A
            INC    DPTR
            CLR    A
            MOVX   @DPTR,A
            MOV    DPTR,#U21CTRL
            MOV    A,#80H
            MOVX   @DPTR,A
            MOV    PSW,#0
            MOV    D_A_BUF,#0

START:      MOV    A,#CLRSCR
            LCALL  SYSCALL
            MOV    DPTR,#DISBUF
            MOV    A,#40H
            MOVX   @DPTR,A
            INC    DPTR
            MOVX   @DPTR,A
            INC    DPTR
            INC    DPTR
            INC    DPTR
            MOVX   @DPTR,A
            INC    DPTR
            MOVX   @DPTR,A

DEM92:      MOV    B,D_A_BUF
            MOV    A,#ONE_TO_TWO
            LCALL  SYSCALL
            MOV    DPTR,#DISBUF+2
            MOVX   @DPTR,A
            INC    DPTR
            MOV    A,B
            MOVX   @DPTR,A
            MOV    A,D_A_BUF
            MOV    DPTR,#DA_PORT
            MOVX   @DPTR,A            ;Output to D/A
            MOV    A,#SCAN_KYDP
            LCALL  SYSCALL
            CJNE   A,#11H,INC_KEY
            DEC    D_A_BUF
            SJMP   BEEP
INC_KEY:    CJNE   A,#13H,DEM93
            INC    D_A_BUF
BEEP:       MOV    A,REPEAT
            JZ     DEM92
            MOV    A,#HI_BEEP
            LCALL  SYSCALL
            SJMP   DEM92
DEM93:      CJNE   A,#10H,DEM94
DEM94:      JNC    DEM92
            MOV    KEY_STAT,#8         ;Release key
            MOV    DPTR,#DISBUF+2
            MOV    A,#GET_2KEY
            LCALL  SYSCALL
            MOV    DPTR,#DISBUF+2
            MOV    A,#TWO_IN_ONE
            LCALL  SYSCALL
            MOV    D_A_BUF,A
            SJMP   DEM92
            END



